//
// $Id: biosregs.h,v 1.2 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//


#ifndef BX_BIOSREGS_H
#define BX_BIOSREGS_H 1

// access to 8 bit general registers
#define AL (cpu->gen_reg[0].word.byte.rl)
#define CL (cpu->gen_reg[1].word.byte.rl)
#define DL (cpu->gen_reg[2].word.byte.rl)
#define BL (cpu->gen_reg[3].word.byte.rl)
#define AH (cpu->gen_reg[0].word.byte.rh)
#define CH (cpu->gen_reg[1].word.byte.rh)
#define DH (cpu->gen_reg[2].word.byte.rh)
#define BH (cpu->gen_reg[3].word.byte.rh)


// access to 16 bit general registers
#define AX (cpu->gen_reg[0].word.rx)
#define CX (cpu->gen_reg[1].word.rx)
#define DX (cpu->gen_reg[2].word.rx)
#define BX (cpu->gen_reg[3].word.rx)
#define SP (cpu->gen_reg[4].word.rx)
#define BP (cpu->gen_reg[5].word.rx)
#define SI (cpu->gen_reg[6].word.rx)
#define DI (cpu->gen_reg[7].word.rx)

// access to 16 bit instruction pointer
#define IP (* (Bit16u *) (((Bit8u *) &cpu->eip) + BX_REG16_OFFSET))


// accesss to 32 bit general registers
#define EAX cpu->gen_reg[0].erx
#define ECX cpu->gen_reg[1].erx
#define EDX cpu->gen_reg[2].erx
#define EBX cpu->gen_reg[3].erx
#define ESP cpu->gen_reg[4].erx
#define EBP cpu->gen_reg[5].erx
#define ESI cpu->gen_reg[6].erx
#define EDI cpu->gen_reg[7].erx

// access to 32 bit instruction pointer
#define EIP cpu->eip

#define TF cpu->eflags.tf
#define IF cpu->eflags.if_
#define DF cpu->eflags.df

#define IOPL cpu->eflags.iopl
#ifndef CPL
#define CPL  (cpu->sregs[BX_SEG_REG_CS].selector.rpl)
#endif

#define DS cpu->sregs[BX_SEG_REG_DS].selector.value

#endif  // #ifndef BX_BIOSREGS_H
